/*
 * Decompiled with CFR 0.152.
 */
package com.junto.create_cobblemon_potion.client;

import com.junto.create_cobblemon_potion.common.fluids.BaseFluidType;
import com.junto.create_cobblemon_potion.core.registry.FluidRegistry;
import com.junto.create_cobblemon_potion.core.registry.FluidTypeRegistry;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@EventBusSubscriber(modid="create_cobblemon_potion", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.MEDICINAL_BREW_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.POTION_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.SUPER_POTION_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.HYPER_POTION_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.MAX_POTION_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.FULL_RESTORE_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.ETHER_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.MAX_ETHER_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.ELIXIR_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.MAX_ELIXIR_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.ANTIDOTE_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.AWAKENING_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.BURN_HEAL_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.ICE_HEAL_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.PARALYZE_HEAL_FLUID_TYPE.get());
        ClientSetup.registerFluidTypeExtension(event, (FluidType)FluidTypeRegistry.FULL_HEAL_FLUID_TYPE.get());
    }

    private static void registerFluidTypeExtension(RegisterClientExtensionsEvent event, FluidType type) {
        if (type instanceof BaseFluidType) {
            final BaseFluidType baseFluidType = (BaseFluidType)type;
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return baseFluidType.getStillTextureRL();
                }

                public ResourceLocation getFlowingTexture() {
                    return baseFluidType.getFlowingTextureRL();
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return baseFluidType.getOverlayTextureRL();
                }

                public int getTintColor() {
                    return baseFluidType.getTintColor();
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return baseFluidType.getFogColor();
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)1.0f);
                    RenderSystem.setShaderFogEnd((float)6.0f);
                }
            }, new FluidType[]{type});
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MEDICINAL_BREW_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MEDICINAL_BREW_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.POTION_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.POTION_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.SUPER_POTION_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.SUPER_POTION_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.HYPER_POTION_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.HYPER_POTION_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MAX_POTION_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MAX_POTION_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.FULL_RESTORE_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.FULL_RESTORE_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ETHER_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ETHER_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MAX_ETHER_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MAX_ETHER_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ELIXIR_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ELIXIR_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MAX_ELIXIR_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.MAX_ELIXIR_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ANTIDOTE_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ANTIDOTE_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.AWAKENING_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.AWAKENING_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.BURN_HEAL_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.BURN_HEAL_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ICE_HEAL_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.ICE_HEAL_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.PARALYZE_HEAL_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.PARALYZE_HEAL_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.FULL_HEAL_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidRegistry.FULL_HEAL_FLOWING.get()), (RenderType)RenderType.translucent());
        });
    }
}

