/*
 * Decompiled with CFR 0.152.
 */
package com.junto.create_cobblemon_potion.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;

public abstract class AbstractEffectLiquidBlock
extends LiquidBlock {
    public static final int MAX_STRENGTH = 255;
    public static final IntegerProperty STRENGTH = IntegerProperty.create((String)"strength", (int)0, (int)255);
    protected final Supplier<? extends FlowingFluid> fluidSupplier;
    private final int initialStrength;
    private final Supplier<BlockState> degradedStateSupplier;

    protected AbstractEffectLiquidBlock(Supplier<? extends FlowingFluid> pFluidSupplier, BlockBehaviour.Properties pProperties, int initialStrength, Supplier<BlockState> degradedStateSupplier) {
        super(pFluidSupplier.get(), pProperties);
        this.fluidSupplier = pFluidSupplier;
        this.initialStrength = Math.min(Math.max(initialStrength, 1), 255);
        this.degradedStateSupplier = degradedStateSupplier;
        FluidState fluidstate = pFluidSupplier.get().getSource(false);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(fluidstate.getAmount()))).setValue((Property)STRENGTH, (Comparable)Integer.valueOf(this.initialStrength)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LEVEL, STRENGTH});
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return (Integer)pState.getValue((Property)STRENGTH) > 0;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int currentStrength = (Integer)pState.getValue((Property)STRENGTH);
        if (currentStrength > 0) {
            int nextStrength = currentStrength - 1;
            if (nextStrength > 0) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)STRENGTH, (Comparable)Integer.valueOf(nextStrength)), 2);
            } else {
                BlockState degradedState = this.degradedStateSupplier.get();
                if (degradedState.hasProperty((Property)LEVEL)) {
                    int currentLevel = (Integer)pState.getValue((Property)LEVEL);
                    degradedState = (BlockState)degradedState.setValue((Property)LEVEL, (Comparable)Integer.valueOf(currentLevel));
                }
                pLevel.setBlock(pPos, degradedState, 2);
            }
        }
    }

    public final void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.isClientSide && pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            int currentStrength = (Integer)pState.getValue((Property)STRENGTH);
            if (currentStrength > 0) {
                this.applyEffect(livingEntity, pLevel, pPos, currentStrength);
            }
        }
        super.entityInside(pState, pLevel, pPos, pEntity);
    }

    protected abstract void applyEffect(LivingEntity var1, Level var2, BlockPos var3, int var4);
}

