/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class PokemonPostRenderer {
    private static final ResourceLocation BEAM_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/beam.png");
    private static final RenderType BEAM_RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)BEAM_LOCATION);

    private static Vec3 getPosition(LivingEntity livingEntity, double yOffset, float partialTick) {
        double d = Mth.lerp((double)partialTick, (double)livingEntity.xOld, (double)livingEntity.getX());
        double e = Mth.lerp((double)partialTick, (double)livingEntity.yOld, (double)livingEntity.getY()) + yOffset;
        double f = Mth.lerp((double)partialTick, (double)livingEntity.zOld, (double)livingEntity.getZ());
        return new Vec3(d, e, f);
    }

    public static void postRender(PokemonEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean enabled;
        LivingEntity livingEntity = entity.getTarget();
        int attackTime = ((PokemonInterface)entity).getAttackTime();
        boolean bl = enabled = ((PokemonInterface)entity).usingBeam() && !entity.isBattling();
        if (livingEntity != null && livingEntity.isAlive() && attackTime > 0 && enabled) {
            Move move = PokemonUtils.getMove(entity);
            if (move == null) {
                CobblemonFightOrFlight.LOGGER.info("Trying to use a null move");
                return;
            }
            float g = 40.0f + partialTicks + (float)attackTime;
            Color color = Color.white;
            color = PokemonAttackEffect.getColorFromType(move.getType().getName());
            float h = g * 0.5f % 1.0f;
            float i = entity.getEyeHeight();
            poseStack.pushPose();
            poseStack.translate(0.0f, i, 0.0f);
            Vec3 vec3 = PokemonPostRenderer.getPosition(livingEntity, (double)livingEntity.getBbHeight() * 0.5, partialTicks);
            Vec3 vec32 = PokemonPostRenderer.getPosition((LivingEntity)entity, i, partialTicks);
            Vec3 vec33 = vec3.subtract(vec32);
            float j = (float)(vec33.length() + 1.0);
            vec33 = vec33.normalize();
            float k = (float)Math.acos(vec33.y);
            float l = (float)Math.atan2(vec33.z, vec33.x);
            poseStack.mulPose(Axis.YP.rotationDegrees((1.5707964f - l) * 57.295776f));
            poseStack.mulPose(Axis.XP.rotationDegrees(k * 57.295776f));
            boolean m = true;
            float n = g * 0.05f * -1.5f;
            int p = color.getRed();
            int q = color.getGreen();
            int r = color.getBlue();
            float s = 0.2f;
            float t = 0.282f;
            float u = Mth.cos((float)(n + 2.3561945f)) * 0.282f;
            float v = Mth.sin((float)(n + 2.3561945f)) * 0.282f;
            float w = Mth.cos((float)(n + 0.7853982f)) * 0.282f;
            float x = Mth.sin((float)(n + 0.7853982f)) * 0.282f;
            float y = Mth.cos((float)(n + 3.926991f)) * 0.282f;
            float z = Mth.sin((float)(n + 3.926991f)) * 0.282f;
            float aa = Mth.cos((float)(n + 5.4977875f)) * 0.282f;
            float ab = Mth.sin((float)(n + 5.4977875f)) * 0.282f;
            float ac = Mth.cos((float)(n + (float)Math.PI)) * 0.2f;
            float ad = Mth.sin((float)(n + (float)Math.PI)) * 0.2f;
            float ae = Mth.cos((float)(n + 0.0f)) * 0.2f;
            float af = Mth.sin((float)(n + 0.0f)) * 0.2f;
            float ag = Mth.cos((float)(n + 1.5707964f)) * 0.2f;
            float ah = Mth.sin((float)(n + 1.5707964f)) * 0.2f;
            float ai = Mth.cos((float)(n + 4.712389f)) * 0.2f;
            float aj = Mth.sin((float)(n + 4.712389f)) * 0.2f;
            float al = 0.0f;
            float am = 0.4999f;
            float an = -1.0f + h;
            float ao = j * 2.5f + an;
            VertexConsumer vertexConsumer = buffer.getBuffer(BEAM_RENDER_TYPE);
            PoseStack.Pose pose = poseStack.last();
            PokemonPostRenderer.vertex(vertexConsumer, pose, ac, j, ad, p, q, r, 0.4999f, ao);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ac, 0.0f, ad, p, q, r, 0.4999f, an);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ae, 0.0f, af, p, q, r, 0.0f, an);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ae, j, af, p, q, r, 0.0f, ao);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ag, j, ah, p, q, r, 0.4999f, ao);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ag, 0.0f, ah, p, q, r, 0.4999f, an);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ai, 0.0f, aj, p, q, r, 0.0f, an);
            PokemonPostRenderer.vertex(vertexConsumer, pose, ai, j, aj, p, q, r, 0.0f, ao);
            float ap = 0.0f;
            if (entity.tickCount % 2 == 0) {
                ap = 0.5f;
            }
            PokemonPostRenderer.vertex(vertexConsumer, pose, u, j, v, p, q, r, 0.5f, ap + 0.5f);
            PokemonPostRenderer.vertex(vertexConsumer, pose, w, j, x, p, q, r, 1.0f, ap + 0.5f);
            PokemonPostRenderer.vertex(vertexConsumer, pose, aa, j, ab, p, q, r, 1.0f, ap);
            PokemonPostRenderer.vertex(vertexConsumer, pose, y, j, z, p, q, r, 0.5f, ap);
            poseStack.popPose();
        }
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, float x, float y, float z, int red, int green, int blue, float u, float v) {
        consumer.addVertex(pose, x, y, z).setColor(red, green, blue, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }
}

