/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import me.rufia.fightorflight.client.model.PokemonTransformingProjectileModel;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonSpike;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class PokemonStickyWebRenderer
extends EntityRenderer<AbstractPokemonSpike> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"fightorflight", (String)"textures/entity/sticky_web.png");
    private final PokemonTransformingProjectileModel<AbstractPokemonSpike> model;

    public PokemonStickyWebRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new PokemonTransformingProjectileModel(context.bakeLayer(PokemonTransformingProjectileModel.LAYER_LOCATION));
    }

    public void render(AbstractPokemonSpike entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        int inGroundTick = entity.getInGroundTick();
        poseStack.pushPose();
        float h = inGroundTick == -1 ? (float)entity.tickCount + partialTicks : (float)inGroundTick;
        float y = inGroundTick == -1 ? -1.5f : -1.45f;
        poseStack.scale(0.75f, 0.75f, 0.75f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.cos((float)(h * 0.1f)) * 180.0f));
        poseStack.translate(0.0f, y, 0.0f);
        VertexConsumer vertexConsumer = buffer.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        Color color = Color.white;
        int colorCode = FastColor.ARGB32.colorFromFloat((float)0.5f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        if (inGroundTick == -1) {
            this.model.renderMain(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        } else {
            this.model.renderSide(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, colorCode);
        }
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(AbstractPokemonSpike entity) {
        return TEXTURE_LOCATION;
    }
}

