/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.Objects;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public abstract class AbstractPokemonProjectile
extends ThrowableProjectile {
    private static final EntityDataAccessor<String> type = SynchedEntityData.defineId(AbstractPokemonProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Float> damage = SynchedEntityData.defineId(AbstractPokemonProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public AbstractPokemonProjectile(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void initPosition(LivingEntity shooter) {
        this.setOwner((Entity)shooter);
        BlockPos blockPos = shooter.blockPosition();
        float angle = shooter.getYRot();
        double radius = 0.5 * (double)shooter.getBbWidth();
        double d = (double)blockPos.getX() + 0.5 - radius * Math.sin(angle);
        double e = (double)blockPos.getY() + Math.max((double)0.3f, (double)shooter.getBbHeight() * 0.67);
        double f = (double)blockPos.getZ() + 0.5 + radius * Math.cos(angle);
        this.moveTo(d, e, f, this.getYRot(), this.getXRot());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Type", (String)this.entityData.get(type));
        compound.putFloat("Damage", ((Float)this.entityData.get(damage)).floatValue());
    }

    public void tick() {
        super.tick();
        if (this.shoudlCreateParticle()) {
            this.makeParticle(2);
        }
    }

    protected boolean shoudlCreateParticle() {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(type, (Object)compound.getString("Type"));
        this.entityData.set(damage, (Object)Float.valueOf(compound.getFloat("Damage")));
    }

    protected void makeParticle(int particleAmount) {
        if (this.getElementalType() == null) {
            return;
        }
        PokemonAttackEffect.makeTypeEffectParticle(particleAmount, (Entity)this, this.getElementalType());
    }

    public float getDamage() {
        return ((Float)this.entityData.get(damage)).floatValue();
    }

    public void setDamage(float Damage) {
        this.entityData.set(damage, (Object)Float.valueOf(Damage));
    }

    public String getElementalType() {
        return (String)this.entityData.get(type);
    }

    public void setElementalType(String Type2) {
        this.entityData.set(type, (Object)Type2);
    }

    public void applyTypeEffect(PokemonEntity pokemonEntity, LivingEntity hurtTarget) {
        if (!Objects.equals(this.getElementalType(), pokemonEntity.getPokemon().getPrimaryType().getName())) {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, (Entity)hurtTarget, this.getElementalType());
        } else {
            PokemonAttackEffect.applyTypeEffect(pokemonEntity, (Entity)hurtTarget);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(type, (Object)"normal");
        builder.define(damage, (Object)Float.valueOf(1.0f));
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity owner = this.getOwner();
        Entity target = result.getEntity();
        if (owner instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)owner;
            if (target instanceof LivingEntity) {
                Move move = PokemonUtils.getMove(pokemonEntity);
                PokemonUtils.setHurtByPlayer(pokemonEntity, target);
                PokemonAttackEffect.applyOnHitVisualEffect(pokemonEntity, target, move);
            }
        }
    }

    protected boolean canHitEntity(Entity target) {
        return target != this.getOwner() && super.canHitEntity(target);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
    }

    public void accurateShoot(double x, double y, double z, float velocity, float inaccuracy) {
        double horizontalDistance = Math.sqrt(x * x + z * z);
        float g = (float)this.getGravity();
        double v2 = velocity * velocity;
        double sqrtDelta = Math.sqrt(v2 * v2 - 2.0 * v2 * (double)g * y - (double)(g * g) * horizontalDistance * horizontalDistance);
        double t = Math.sqrt(2.0 * (v2 - (double)g * y - sqrtDelta)) / (double)g;
        double vy = 0.5 * (double)g * t + y;
        this.shoot(x, y, z, velocity, inaccuracy);
    }
}

