/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import java.util.List;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractPokemonSpike
extends AbstractPokemonProjectile {
    protected boolean inGround;
    protected int inGroundTime;
    protected short life;
    protected String type;
    protected BlockState lastState;
    protected boolean activated;
    private static final EntityDataAccessor<Integer> IN_GROUND_TICK = SynchedEntityData.defineId(AbstractPokemonSpike.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AbstractPokemonSpike(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected boolean shouldFall() {
        return this.inGround && this.level().noCollision(new AABB(this.position(), this.position()).inflate(0.1));
    }

    protected void startFalling() {
        this.inGround = false;
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.multiply((double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f), (double)(this.random.nextFloat() * 0.2f)));
    }

    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), this::canHitEntity);
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        this.lastState = this.level().getBlockState(result.getBlockPos());
        super.onHitBlock(result);
        Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3);
        Vec3 vec31 = vec3.normalize().scale(0.05);
        this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
        this.inGround = true;
    }

    protected void checkEntityCollision() {
        if (!this.level().isClientSide && this.activated) {
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(0.1));
            for (LivingEntity livingEntity : list) {
                if (this.getOwner() == livingEntity || livingEntity.xOld == livingEntity.getX() || livingEntity.zOld == livingEntity.getZ()) continue;
                double d = Math.abs(livingEntity.getX() - livingEntity.xOld);
                double e = Math.abs(livingEntity.getZ() - livingEntity.zOld);
                if (!(d >= 0.003) && !(e >= 0.003)) continue;
                this.hurtEntity(livingEntity);
            }
        }
    }

    protected abstract void hurtEntity(LivingEntity var1);

    public void move(MoverType type, Vec3 pos) {
        super.move(type, pos);
        if (type != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    protected void tickDespawn() {
        Entity owner = this.getOwner();
        this.life = owner != null && owner.isAlive() ? (short)(this.life + 1) : (short)(this.life + 10);
        if (this.life >= this.getMaxLife()) {
            this.discard();
        }
    }

    @Override
    public void tick() {
        Vec3 vec33;
        VoxelShape voxelshape;
        super.tick();
        if (this.inGround) {
            if (this.getInGroundTick() == -1) {
                int randomInterval = this.level().random.nextInt(20);
                this.setInGroundTick(this.tickCount + randomInterval);
            }
        } else {
            this.setInGroundTick(-1);
        }
        if (this.activated && !this.level().isClientSide) {
            this.tickDespawn();
        }
        this.checkEntityCollision();
        boolean flag = this.noPhysics;
        Vec3 vec3 = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double d0 = vec3.horizontalDistance();
            this.setYRot(FOFUtils.toAngle(Mth.atan2((double)vec3.x, (double)vec3.z)));
            this.setXRot(FOFUtils.toAngle(Mth.atan2((double)vec3.y, (double)d0)));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!(blockstate.isAir() || flag || (voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty())) {
            vec33 = this.position();
            for (AABB aabb : voxelshape.toAabbs()) {
                if (!aabb.move(blockpos).contains(vec33)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.inGround && !flag) {
            if (!this.activated) {
                this.activated = true;
                this.onActivated();
            }
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            Vec3 vec32 = this.position();
            vec33 = vec32.add(vec3);
            BlockHitResult hitResult = this.level().clip(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitResult.getType() != HitResult.Type.MISS) {
                vec33 = hitResult.getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult entityHitResult = this.findHitEntity(vec32, vec33);
                if (entityHitResult != null && (hitResult = entityHitResult).getType() == HitResult.Type.ENTITY) {
                    Entity entity = entityHitResult.getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        hitResult = null;
                        entityHitResult = null;
                    }
                }
                if (hitResult != null && !flag) {
                    ProjectileDeflection projectileDeflection = this.hitTargetOrDeflectSelf((HitResult)hitResult);
                    this.hasImpulse = true;
                    if (projectileDeflection != ProjectileDeflection.NONE) break;
                }
                if (entityHitResult == null) break;
                hitResult = null;
            }
            vec3 = this.getDeltaMovement();
            double dx = vec3.x;
            double dy = vec3.y;
            double dz = vec3.z;
            double d4 = vec3.horizontalDistance();
            if (flag) {
                this.setYRot(FOFUtils.toAngle(Mth.atan2((double)(-dx), (double)(-dz))));
            } else {
                this.setYRot(FOFUtils.toAngle(Mth.atan2((double)dx, (double)dz)));
            }
            this.setXRot(FOFUtils.toAngle(Mth.atan2((double)dy, (double)d4)));
            this.setXRot(AbstractPokemonSpike.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(AbstractPokemonSpike.lerpRotation((float)this.yRotO, (float)this.getYRot()));
        }
    }

    protected void onActivated() {
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putShort("life", this.life);
        compound.putBoolean("activated", this.activated);
        compound.putBoolean("inGround", this.inGround);
        if (this.lastState != null) {
            compound.put("inBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.lastState));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.life = compound.getShort("life");
        this.activated = compound.getBoolean("activated");
        this.inGround = compound.getBoolean("inGround");
        if (compound.contains("inBlockState", 10)) {
            this.lastState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compound.getCompound("inBlockState"));
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IN_GROUND_TICK, (Object)-1);
    }

    public void setInGroundTick(int value) {
        this.entityData.set(IN_GROUND_TICK, (Object)value);
    }

    public int getInGroundTick() {
        return (Integer)this.entityData.get(IN_GROUND_TICK);
    }

    protected int getMaxLife() {
        return 300;
    }

    @Override
    protected boolean shoudlCreateParticle() {
        return false;
    }

    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected boolean canHitEntity(Entity target) {
        return false;
    }
}

