/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.entity.projectile;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.projectile.AbstractPokemonProjectile;
import me.rufia.fightorflight.utils.PokemonUtils;
import me.rufia.fightorflight.utils.explosion.FOFExplosion;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public abstract class ExplosivePokemonProjectile
extends AbstractPokemonProjectile {
    public ExplosivePokemonProjectile(EntityType<? extends AbstractPokemonProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void explode(PokemonEntity owner) {
        this.level().broadcastEntityEvent((Entity)this, (byte)17);
        this.gameEvent((Holder)GameEvent.EXPLODE, this.getOwner());
        this.dealExplosionDamage(owner);
        this.discard();
    }

    protected void dealExplosionDamage(PokemonEntity owner) {
        if (owner == null) {
            return;
        }
        FOFExplosion explosion = FOFExplosion.createExplosion((Entity)this, owner, this.getX(), this.getY(), this.getZ(), true, true);
        if (explosion != null) {
            explosion.explode();
            explosion.finalizeExplosion();
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        Entity entity;
        BlockPos blockPos = new BlockPos((Vec3i)result.getBlockPos());
        this.level().getBlockState(blockPos).entityInside(this.level(), blockPos, (Entity)this);
        if (!this.level().isClientSide() && (entity = this.getOwner()) instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            this.explode(pokemonEntity);
        }
        super.onHitBlock(result);
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        Entity owner = this.getOwner();
        if (owner instanceof PokemonEntity) {
            LivingEntity hurtTarget;
            PokemonEntity pokemonEntity = (PokemonEntity)owner;
            Entity entity = result.getEntity();
            if (entity instanceof LivingEntity && !PokemonUtils.pokemonTryForceEncounter(pokemonEntity, (Entity)(hurtTarget = (LivingEntity)entity)) && PokemonAttackEffect.shouldHurtAllyMob(pokemonEntity, hurtTarget)) {
                PokemonAttackEffect.applyPostEffect(pokemonEntity, hurtTarget, PokemonUtils.getMove(pokemonEntity), true);
                this.explode(pokemonEntity);
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
    }
}

