/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.item;

import com.cobblemon.mod.common.client.CobblemonClient;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Objects;
import me.rufia.fightorflight.item.component.ItemComponentFOF;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.packet.SendCommandPacket;
import me.rufia.fightorflight.net.packet.SendMoveSlotPacket;
import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PokeStaff
extends Item {
    public PokeStaff(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        String mode = this.getMode(stack);
        if (!mode.isEmpty()) {
            int d = this.getMoveSlot(stack);
            String cmdMode = this.getCommandMode(stack);
            tooltipComponents.add((Component)Component.translatable((String)"item.fightorflight.pokestaff.desc1").append((Component)(switch (PokeStaffComponent.MODE.valueOf(mode)) {
                case PokeStaffComponent.MODE.SEND -> Component.translatable((String)"item.fightorflight.pokestaff.mode.send");
                case PokeStaffComponent.MODE.SETMOVE -> Component.translatable((String)"item.fightorflight.pokestaff.mode.selectmoveslot");
                case PokeStaffComponent.MODE.SETCMDMODE -> Component.translatable((String)"item.fightorflight.pokestaff.mode.selectcommand");
                default -> Component.literal((String)"");
            })));
            tooltipComponents.add((Component)Component.translatable((String)"item.fightorflight.pokestaff.desc2", (Object[])new Object[]{d + 1}));
            tooltipComponents.add((Component)Component.translatable((String)"item.fightorflight.pokestaff.desc3", (Object[])new Object[]{PokeStaff.getTranslatedCmdModeName(cmdMode).getString()}));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isSecondaryUseActive()) {
            this.setMode(stack, PokeStaffComponent.getNextMode(this.getMode(stack)));
            switch (PokeStaffComponent.MODE.valueOf(this.getMode(stack))) {
                case SETMOVE: {
                    if (!player.level().isClientSide) break;
                    player.sendSystemMessage((Component)Component.translatable((String)"item.fightorflight.pokestaff.mode.selectmoveslot"));
                    break;
                }
                case SEND: {
                    if (!player.level().isClientSide) break;
                    player.sendSystemMessage((Component)Component.translatable((String)"item.fightorflight.pokestaff.mode.send"));
                    break;
                }
                case SETCMDMODE: {
                    if (!player.level().isClientSide) break;
                    player.sendSystemMessage((Component)Component.translatable((String)"item.fightorflight.pokestaff.mode.selectcommand"));
                }
            }
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        String mode = this.getMode(stack);
        if (mode.equals(PokeStaffComponent.MODE.SETMOVE.name())) {
            int nextMoveSlot = this.getMoveSlot(stack) + 1;
            this.setMoveSlot(stack, nextMoveSlot);
            this.setCommandMode(stack, PokeStaffComponent.CMDMODE.NOCMD.name());
            if (player.level().isClientSide) {
                player.sendSystemMessage((Component)Component.translatable((String)"item.fightorflight.pokestaff.desc2", (Object[])new Object[]{nextMoveSlot % 4 + 1}));
            }
        }
        if (mode.equals(PokeStaffComponent.MODE.SETCMDMODE.name())) {
            this.commandModeSelectNext(stack, this.getCommandMode(stack));
            this.setMoveSlot(stack, -1);
            if (player.level().isClientSide) {
                player.sendSystemMessage(PokeStaff.getTranslatedCmdModeName(this.getCommandMode(stack)));
            }
        }
        if (mode.equals(PokeStaffComponent.MODE.SEND.name())) {
            PokeStaffComponent.CMDMODE cmdmode = PokeStaffComponent.CMDMODE.valueOf(this.getCommandMode(stack));
            String cmdData = FOFUtils.createCommandData(player, cmdmode);
            if (player.level().isClientSide) {
                int slot = CobblemonClient.INSTANCE.getStorage().getSelectedSlot();
                if (!Objects.equals(this.getCommandMode(stack), PokeStaffComponent.CMDMODE.NOCMD.name())) {
                    NetworkManager.sendToServer((CustomPacketPayload)new SendCommandPacket(slot, this.getCommandMode(stack), cmdData, true));
                } else {
                    NetworkManager.sendToServer((CustomPacketPayload)new SendMoveSlotPacket(slot, this.getMoveSlot(stack), true));
                }
            }
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    protected String getMode(ItemStack itemStack) {
        PokeStaffComponent component;
        if (itemStack.has(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT) && (component = (PokeStaffComponent)itemStack.get(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) != null) {
            return component.mode();
        }
        return "";
    }

    public int getMoveSlot(ItemStack itemStack) {
        PokeStaffComponent component;
        if (itemStack.has(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT) && (component = (PokeStaffComponent)itemStack.get(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) != null) {
            return component.moveSlot();
        }
        return -1;
    }

    public String getCommandMode(ItemStack itemStack) {
        PokeStaffComponent component;
        if (itemStack.has(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT) && (component = (PokeStaffComponent)itemStack.get(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) != null) {
            return component.cmdmode();
        }
        return PokeStaffComponent.CMDMODE.NOCMD.name();
    }

    public boolean useOnRelease(ItemStack stack) {
        return true;
    }

    public void setMoveSlot(ItemStack stack, int moveSlot) {
        PokeStaffComponent component;
        if (stack.has(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT) && (component = (PokeStaffComponent)stack.get(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) != null) {
            component.setMoveSlot(moveSlot % 4, stack);
        }
    }

    public void setCommandMode(ItemStack stack, String mode) {
        PokeStaffComponent component;
        if (stack.has(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT) && (component = (PokeStaffComponent)stack.get(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) != null) {
            component.setCmdmode(mode, stack);
        }
    }

    public void setMode(ItemStack stack, String mode) {
        PokeStaffComponent component;
        if (stack.has(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT) && (component = (PokeStaffComponent)stack.get(ItemComponentFOF.POKE_STAFF_COMMAND_MODE_COMPONENT)) != null) {
            component.setMode(mode, stack);
        }
    }

    protected void commandModeSelectNext(ItemStack stack, String mode) {
        this.setCommandMode(stack, switch (PokeStaffComponent.CMDMODE.valueOf(mode)) {
            case PokeStaffComponent.CMDMODE.MOVE_ATTACK -> PokeStaffComponent.CMDMODE.MOVE.name();
            case PokeStaffComponent.CMDMODE.MOVE -> PokeStaffComponent.CMDMODE.STAY.name();
            case PokeStaffComponent.CMDMODE.STAY -> PokeStaffComponent.CMDMODE.ATTACK.name();
            case PokeStaffComponent.CMDMODE.ATTACK -> PokeStaffComponent.CMDMODE.ATTACK_POSITION.name();
            case PokeStaffComponent.CMDMODE.ATTACK_POSITION -> PokeStaffComponent.CMDMODE.NOCMD.name();
            case PokeStaffComponent.CMDMODE.NOCMD -> PokeStaffComponent.CMDMODE.CLEAR.name();
            case PokeStaffComponent.CMDMODE.CLEAR -> PokeStaffComponent.CMDMODE.MOVE_ATTACK.name();
            default -> PokeStaffComponent.CMDMODE.NOCMD.name();
        });
    }

    public static Component getTranslatedCmdModeName(String cmdModeName) {
        return switch (PokeStaffComponent.CMDMODE.valueOf(cmdModeName)) {
            case PokeStaffComponent.CMDMODE.MOVE_ATTACK -> Component.translatable((String)"item.fightorflight.pokestaff.command.move_attack");
            case PokeStaffComponent.CMDMODE.MOVE -> Component.translatable((String)"item.fightorflight.pokestaff.command.move");
            case PokeStaffComponent.CMDMODE.STAY -> Component.translatable((String)"item.fightorflight.pokestaff.command.stay");
            case PokeStaffComponent.CMDMODE.ATTACK -> Component.translatable((String)"item.fightorflight.pokestaff.command.attack_target");
            case PokeStaffComponent.CMDMODE.ATTACK_POSITION -> Component.translatable((String)"item.fightorflight.pokestaff.command.attack_position");
            case PokeStaffComponent.CMDMODE.CLEAR -> Component.translatable((String)"item.fightorflight.pokestaff.command.clear_cmd");
            default -> Component.translatable((String)"item.fightorflight.pokestaff.command.no_cmd");
        };
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

