/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.mixin;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.server.BattleChallengePacket;
import com.cobblemon.mod.common.net.messages.server.RequestPlayerInteractionsPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import me.rufia.fightorflight.client.keybinds.CommandKeybind;
import me.rufia.fightorflight.client.keybinds.KeybindFightOrFlight;
import me.rufia.fightorflight.item.ItemFightOrFlight;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.packet.SendCommandPacket;
import me.rufia.fightorflight.net.packet.SendMoveSlotPacket;
import me.rufia.fightorflight.utils.FOFUtils;
import me.rufia.fightorflight.utils.PokemonUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftClientInject {
    @Shadow
    @Nullable
    public LocalPlayer player;

    @Shadow
    public static Minecraft getInstance() {
        return null;
    }

    @Inject(method={"handleKeybinds()V"}, at={@At(value="TAIL")})
    private void postTick(CallbackInfo ci) {
        if (KeybindFightOrFlight.START_BATTLE.consumeClick()) {
            this.startBattle();
        }
        if (KeybindFightOrFlight.MOVE_SLOT_1.consumeClick()) {
            this.sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_1.getMoveSlot());
        } else if (KeybindFightOrFlight.MOVE_SLOT_2.consumeClick()) {
            this.sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_2.getMoveSlot());
        } else if (KeybindFightOrFlight.MOVE_SLOT_3.consumeClick()) {
            this.sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_3.getMoveSlot());
        } else if (KeybindFightOrFlight.MOVE_SLOT_4.consumeClick()) {
            this.sendMoveSlotPacket(KeybindFightOrFlight.MOVE_SLOT_4.getMoveSlot());
        }
        for (CommandKeybind keybind : KeybindFightOrFlight.commandKeybinds) {
            if (!keybind.consumeClick()) continue;
            this.sendCommandModePacket(keybind.getCmdmode());
            break;
        }
    }

    private void sendMoveSlotPacket(int moveSlot) {
        if (MinecraftClientInject.getInstance() == null) {
            return;
        }
        LocalPlayer player = MinecraftClientInject.getInstance().player;
        if (player != null) {
            ItemStack stack;
            if (PokemonUtils.shouldCheckPokeStaff() && !(stack = player.getMainHandItem()).is((Item)ItemFightOrFlight.POKESTAFF.get()) && !player.getOffhandItem().is((Item)ItemFightOrFlight.POKESTAFF.get())) {
                return;
            }
            int slot = CobblemonClient.INSTANCE.getStorage().getSelectedSlot();
            NetworkManager.sendToServer((CustomPacketPayload)new SendMoveSlotPacket(slot, moveSlot));
        }
    }

    private void sendCommandModePacket(PokeStaffComponent.CMDMODE cmdmode) {
        LocalPlayer player = MinecraftClientInject.getInstance().player;
        if (player == null) {
            return;
        }
        String cmdData = FOFUtils.createCommandData((Player)player, cmdmode);
        int slot = CobblemonClient.INSTANCE.getStorage().getSelectedSlot();
        NetworkManager.sendToServer((CustomPacketPayload)new SendCommandPacket(slot, cmdmode.name(), cmdData));
    }

    private void startBattle() {
        boolean otherConditions;
        LocalPlayer player = MinecraftClientInject.getInstance().player;
        boolean isSpectator = player.isSpectator();
        boolean playerIsNotAvailable = CobblemonClient.INSTANCE.getBattle() != null;
        boolean bl = otherConditions = CobblemonClient.INSTANCE.getStorage().getSelectedSlot() == -1 || MinecraftClientInject.getInstance().screen != null;
        if (isSpectator || playerIsNotAvailable || otherConditions) {
            return;
        }
        Pokemon pokemon = CobblemonClient.INSTANCE.getStorage().getMyParty().get(CobblemonClient.INSTANCE.getStorage().getSelectedSlot());
        if (pokemon != null && pokemon.getCurrentHealth() > 0) {
            List entities = player.clientLevel.getEntitiesOfClass(PokemonEntity.class, AABB.ofSize((Vec3)player.getPosition((float)player.tickCount), (double)16.0, (double)16.0, (double)16.0), pokemonEntity -> pokemonEntity.getTarget() == player);
            for (PokemonEntity pokemonEntity2 : entities) {
                if (pokemonEntity2.getOwner() == null && pokemonEntity2.canBattle((Player)player)) {
                    BattleChallengePacket packet = new BattleChallengePacket(pokemonEntity2.getId(), pokemon.getUuid(), BattleFormat.Companion.getGEN_9_SINGLES());
                    CobblemonNetwork.INSTANCE.sendToServer((NetworkPacket)packet);
                    break;
                }
                if (pokemonEntity2.getOwner() == player || !(pokemonEntity2.getOwner() instanceof Player)) continue;
                CobblemonNetwork.INSTANCE.sendToServer((NetworkPacket)new RequestPlayerInteractionsPacket(pokemonEntity2.getUUID(), pokemonEntity2.getId(), pokemon.getUuid()));
            }
        }
    }
}

