/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.net.handler;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import dev.architectury.networking.NetworkManager;
import me.rufia.fightorflight.PokemonInterface;
import me.rufia.fightorflight.item.PokeStaff;
import me.rufia.fightorflight.item.component.PokeStaffComponent;
import me.rufia.fightorflight.net.handler.PokeStaffCmdHandler;
import me.rufia.fightorflight.net.packet.SendCommandPacket;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SendCommandHandler
extends PokeStaffCmdHandler<SendCommandPacket> {
    private String cmdData;
    private String cmdMode;

    @Override
    public void handle(SendCommandPacket packet, NetworkManager.PacketContext context) {
        this.cmdData = packet.getCommandData();
        this.cmdMode = packet.getCommand();
        this.handlePacket(packet, context);
    }

    @Override
    protected void editStaff(ItemStack stack, SendCommandPacket packet) {
        PokeStaff staff = (PokeStaff)stack.getItem();
        if (!packet.isFromPokeStaff()) {
            staff.setMoveSlot(stack, -1);
            staff.setCommandMode(stack, this.cmdMode);
            staff.setMode(stack, PokeStaffComponent.MODE.SEND.name());
        }
    }

    @Override
    protected void finalProcess(PokemonEntity pokemonEntity, Player player, SendCommandPacket packet) {
        ((PokemonInterface)pokemonEntity).setCommand(this.cmdMode);
        ((PokemonInterface)pokemonEntity).setCommandData(this.cmdData);
        player.sendSystemMessage((Component)Component.translatable((String)"item.fightorflight.pokestaff.command", (Object[])new Object[]{pokemonEntity.getPokemon().getDisplayName(), PokeStaff.getTranslatedCmdModeName(this.cmdMode)}));
    }
}

