/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.utils.listeners;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import me.rufia.fightorflight.CobblemonFightOrFlight;
import me.rufia.fightorflight.data.movedata.MoveData;
import me.rufia.fightorflight.data.movedata.MoveDataContainer;
import me.rufia.fightorflight.data.movedata.container.MiscMoveDataContainer;
import me.rufia.fightorflight.data.movedata.container.StatChangeMoveDataContainer;
import me.rufia.fightorflight.data.movedata.container.StatusEffectMoveDataContainer;
import me.rufia.fightorflight.utils.FOFUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class MoveDataListener
extends SimplePreparableReloadListener<Map<ResourceLocation, MoveDataContainer>> {
    protected Map<ResourceLocation, MoveDataContainer> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, MoveDataContainer> map = new HashMap<ResourceLocation, MoveDataContainer>();
        CobblemonFightOrFlight.LOGGER.info("[FOF] Preparing to read move data");
        this.prepareTag(resourceManager, "stat", (Type)((Object)StatChangeMoveDataContainer.class), (Map<ResourceLocation, MoveDataContainer>)map);
        this.prepareTag(resourceManager, "status", (Type)((Object)StatusEffectMoveDataContainer.class), (Map<ResourceLocation, MoveDataContainer>)map);
        this.prepareTag(resourceManager, "misc", (Type)((Object)MiscMoveDataContainer.class), (Map<ResourceLocation, MoveDataContainer>)map);
        return map;
    }

    private void prepareTag(ResourceManager resourceManager, String tagName, Type type, Map<ResourceLocation, MoveDataContainer> map) {
        for (Map.Entry entry : resourceManager.listResources("fof_move_data/" + tagName, fileName -> fileName.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            Resource resource = (Resource)entry.getValue();
            try {
                JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.open()));
                Gson gson = new Gson();
                map.put(resourceLocation, (MoveDataContainer)gson.fromJson(reader, type));
            }
            catch (Exception e) {
                CobblemonFightOrFlight.LOGGER.warn("Failed to read {}", (Object)resourceLocation);
            }
        }
    }

    private void register(Map<String, ? extends MoveData> dataMap) {
        for (Map.Entry<String, ? extends MoveData> mapEntry : dataMap.entrySet()) {
            FOFUtils.registerMoveData(mapEntry.getKey(), mapEntry.getValue());
        }
    }

    protected void apply(Map<ResourceLocation, MoveDataContainer> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        MoveData.moveData.clear();
        int fileCount = 0;
        for (Map.Entry<ResourceLocation, MoveDataContainer> entry : map.entrySet()) {
            ResourceLocation location = entry.getKey();
            MoveDataContainer container = entry.getValue();
            Map<String, MoveData> dataMap = null;
            if (container instanceof StatChangeMoveDataContainer) {
                StatChangeMoveDataContainer statChangeMoveDataContainer = (StatChangeMoveDataContainer)container;
                dataMap = statChangeMoveDataContainer.build();
            } else if (container instanceof StatusEffectMoveDataContainer) {
                StatusEffectMoveDataContainer statusEffectMoveDataContainer = (StatusEffectMoveDataContainer)container;
                dataMap = statusEffectMoveDataContainer.build();
            } else if (container instanceof MiscMoveDataContainer) {
                MiscMoveDataContainer miscMoveDataContainer = (MiscMoveDataContainer)container;
                dataMap = miscMoveDataContainer.build();
            }
            if (dataMap == null) continue;
            this.register(dataMap);
            ++fileCount;
        }
        CobblemonFightOrFlight.LOGGER.info("[FOF] {} move data files processed.", (Object)fileCount);
        CobblemonFightOrFlight.fromConfigToMoveData();
    }
}

