/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.AbstractDataSourceHandler;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.WillNotClose;
import org.apache.logging.log4j.Logger;

public class ClientLevelModule
implements Closeable,
AbstractDataSourceHandler.IDataSourceUpdateFunc<FullDataSourceV2> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private final IDhClientLevel clientLevel;
    @WillNotClose
    public final FullDataSourceProviderV2 fullDataSourceProvider;
    public final AtomicReference<ClientRenderState> ClientRenderStateRef = new AtomicReference();
    public final GenericObjectRenderer genericRenderer = new GenericObjectRenderer();
    private EDhApiDebugRendering lastDebugRendering = EDhApiDebugRendering.OFF;

    public ClientLevelModule(IDhClientLevel clientLevel) {
        this.clientLevel = clientLevel;
        this.fullDataSourceProvider = this.clientLevel.getFullDataProvider();
        this.fullDataSourceProvider.dateSourceUpdateListeners.add(this);
    }

    public void clientTick() {
        if (!MC_CLIENT.playerExists()) {
            return;
        }
        ClientRenderState clientRenderState = this.ClientRenderStateRef.get();
        if (clientRenderState == null) {
            return;
        }
        if (clientRenderState.quadtree.blockRenderDistanceDiameter != Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16 * 2) {
            if (!this.ClientRenderStateRef.compareAndSet(clientRenderState, null)) {
                return;
            }
            IClientLevelWrapper clientLevelWrapper = this.clientLevel.getClientLevelWrapper();
            if (clientLevelWrapper == null) {
                return;
            }
            clientRenderState.close();
            clientRenderState = new ClientRenderState(this.clientLevel, clientLevelWrapper, this.clientLevel.getFullDataProvider(), this.genericRenderer);
            if (!this.ClientRenderStateRef.compareAndSet(null, clientRenderState)) {
                LOGGER.warn("Failed to set render state due to concurrency after changing view distance");
                clientRenderState.close();
                return;
            }
        }
        clientRenderState.quadtree.tick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
        boolean isBuffersDirty = false;
        EDhApiDebugRendering newDebugRendering = Config.Client.Advanced.Debugging.debugRendering.get();
        if (newDebugRendering != this.lastDebugRendering) {
            this.lastDebugRendering = newDebugRendering;
            isBuffersDirty = true;
        }
        if (isBuffersDirty) {
            clientRenderState.lodRenderer.bufferHandler.MarkAllBuffersDirty();
        }
    }

    public boolean startRenderer(IClientLevelWrapper clientLevelWrapper) {
        ClientRenderState ClientRenderState2 = new ClientRenderState(this.clientLevel, clientLevelWrapper, this.clientLevel.getFullDataProvider(), this.genericRenderer);
        if (!this.ClientRenderStateRef.compareAndSet(null, ClientRenderState2)) {
            LOGGER.warn("Failed to start renderer due to concurrency");
            ClientRenderState2.close();
            return false;
        }
        return true;
    }

    public boolean isRendering() {
        return this.ClientRenderStateRef.get() != null;
    }

    public void render(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 == null) {
            return;
        }
        ClientRenderState2.lodRenderer.drawLods(ClientRenderState2.clientLevelWrapper, renderEventParam, profiler);
    }

    public void renderDeferred(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 == null) {
            return;
        }
        ClientRenderState2.lodRenderer.drawDeferredLods(ClientRenderState2.clientLevelWrapper, renderEventParam, profiler);
    }

    public void stopRenderer() {
        LOGGER.info("Stopping renderer for " + this);
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 == null) {
            LOGGER.warn("Tried to stop renderer for " + this + " when it was not started!");
            return;
        }
        while (!this.ClientRenderStateRef.compareAndSet(ClientRenderState2, null)) {
            ClientRenderState2 = this.ClientRenderStateRef.get();
            if (ClientRenderState2 != null) continue;
            return;
        }
        ClientRenderState2.close();
    }

    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return this.clientLevel.getFullDataProvider().updateDataSourceAsync(data);
    }

    @Override
    public void OnDataSourceUpdated(FullDataSourceV2 updatedFullDataSource) {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            ClientRenderState2.quadtree.reloadPos(updatedFullDataSource.getPos());
        }
    }

    @Override
    public void close() {
        ClientRenderState ClientRenderState2 = this.ClientRenderStateRef.get();
        if (ClientRenderState2 != null) {
            while (!this.ClientRenderStateRef.compareAndSet(ClientRenderState2, null) && (ClientRenderState2 = this.ClientRenderStateRef.get()) != null) {
            }
            if (ClientRenderState2 != null) {
                ClientRenderState2.close();
            }
        }
        this.fullDataSourceProvider.dateSourceUpdateListeners.remove(this);
    }

    public void clearRenderCache() {
        ClientRenderState ClientRenderState2;
        IClientLevelWrapper clientLevelWrapper = this.clientLevel.getClientLevelWrapper();
        if (clientLevelWrapper != null) {
            clientLevelWrapper.clearBlockColorCache();
        }
        if ((ClientRenderState2 = this.ClientRenderStateRef.get()) != null && ClientRenderState2.quadtree != null) {
            ClientRenderState2.quadtree.clearRenderDataCache();
        }
    }

    public void reloadPos(long pos) {
        ClientRenderState clientRenderState = this.ClientRenderStateRef.get();
        if (clientRenderState != null && clientRenderState.quadtree != null) {
            clientRenderState.quadtree.reloadPos(pos);
        }
    }

    public static class ClientRenderState
    implements Closeable {
        private static final Logger LOGGER = DhLoggerBuilder.getLogger();
        public final IClientLevelWrapper clientLevelWrapper;
        public final LodQuadTree quadtree;
        public final RenderBufferHandler renderBufferHandler;
        public final LodRenderer lodRenderer;

        public ClientRenderState(IDhClientLevel dhClientLevel, IClientLevelWrapper clientLevelWrapper, FullDataSourceProviderV2 fullDataSourceProvider, GenericObjectRenderer genericRenderer) {
            this.clientLevelWrapper = clientLevelWrapper;
            this.quadtree = new LodQuadTree(dhClientLevel, Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16 * 2, 0, 0, fullDataSourceProvider);
            this.renderBufferHandler = new RenderBufferHandler(this.quadtree);
            this.lodRenderer = new LodRenderer(this.renderBufferHandler, genericRenderer);
        }

        @Override
        public void close() {
            LOGGER.info("Shutting down " + ClientRenderState.class.getSimpleName());
            this.lodRenderer.close();
            this.quadtree.close();
        }
    }
}

