/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.sql.dto.ChunkHashDTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChunkHashRepo
extends AbstractDhRepo<DhChunkPos, ChunkHashDTO> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final String insertSqlTemplate = "INSERT INTO " + this.getTableName() + " (\n   ChunkPosX, ChunkPosZ, \n   ChunkHash, \n   LastModifiedUnixDateTime, CreatedUnixDateTime) \nVALUES( \n    ?, ?, \n    ?, \n    ?, ? \n);";
    private final String updateSqlTemplate = "UPDATE " + this.getTableName() + " \nSET \n    ChunkHash = ? \n   ,LastModifiedUnixDateTime = ? \nWHERE ChunkPosX = ? AND ChunkPosZ = ?";

    public ChunkHashRepo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, ChunkHashDTO.class);
    }

    @Override
    public String getTableName() {
        return "ChunkHash";
    }

    @Override
    protected String CreateParameterizedWhereString() {
        return "ChunkPosX = ? AND ChunkPosZ = ?";
    }

    @Override
    protected int setPreparedStatementWhereClause(PreparedStatement statement, int index, DhChunkPos pos) throws SQLException {
        statement.setInt(index++, pos.getX());
        statement.setInt(index++, pos.getZ());
        return index;
    }

    @Override
    @Nullable
    public ChunkHashDTO convertResultSetToDto(ResultSet resultSet) throws ClassCastException, SQLException {
        int posX = resultSet.getInt("ChunkPosX");
        int posZ = resultSet.getInt("ChunkPosZ");
        int chunkHash = resultSet.getInt("ChunkHash");
        ChunkHashDTO dto = new ChunkHashDTO(new DhChunkPos(posX, posZ), chunkHash);
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(ChunkHashDTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.insertSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setObject(i++, dto.pos.getX());
        statement.setObject(i++, dto.pos.getZ());
        statement.setObject(i++, dto.chunkHash);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, System.currentTimeMillis());
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(ChunkHashDTO dto) throws SQLException {
        PreparedStatement statement = this.createPreparedStatement(this.updateSqlTemplate);
        if (statement == null) {
            return null;
        }
        int i = 1;
        statement.setObject(i++, dto.chunkHash);
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, dto.pos.getX());
        statement.setObject(i++, dto.pos.getZ());
        return statement;
    }
}

