/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface PastureInventory
extends Container {
    public NonNullList<ItemStack> getItems();

    public static PastureInventory of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static PastureInventory ofSize(int size) {
        return PastureInventory.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    default public ItemStack getItem() {
        ItemStack itemStack = ItemStack.EMPTY;
        for (int slot = 0; slot < this.getContainerSize() && (itemStack = this.getItem(slot)).getCount() == 0; ++slot) {
        }
        return itemStack;
    }

    @NotNull
    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    default public ItemStack removeItemNoUpdate() {
        ItemStack itemStack = ItemStack.EMPTY;
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            itemStack = this.getItem(slot);
            if (itemStack.getCount() == 0) continue;
            itemStack = this.removeItemNoUpdate(slot);
            break;
        }
        return itemStack;
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(Player player) {
        return true;
    }
}

