/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.gui;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.NetworkManager;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.NeuterProperty;
import ludichat.cobbreeding.network.ToggleNeuterPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J/\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0017H\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eR\"\u0010\b\u001a\u00020\u00078\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010%\u001a\u00020$8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\"\u0010+\u001a\u00020$8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010&\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*\u00a8\u0006."}, d2={"Lludichat/cobbreeding/gui/ToggleNeuterButton;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "", "x", "y", "width", "height", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "<init>", "(IIIILcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "mouseX", "mouseY", "", "onClick", "(DD)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "partialTick", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "narrationElementOutput", "updateWidgetNarration", "(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V", "Lnet/minecraft/client/sounds/SoundManager;", "soundManager", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getPokemon", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "setPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lnet/minecraft/resources/ResourceLocation;", "texture", "Lnet/minecraft/resources/ResourceLocation;", "getTexture", "()Lnet/minecraft/resources/ResourceLocation;", "setTexture", "(Lnet/minecraft/resources/ResourceLocation;)V", "cross", "getCross", "setCross", "common"})
public final class ToggleNeuterButton
extends AbstractWidget {
    @NotNull
    private Pokemon pokemon;
    @NotNull
    private ResourceLocation texture;
    @NotNull
    private ResourceLocation cross;

    public ToggleNeuterButton(int x, int y, int width, int height, @NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        super(x, y, width, height, (Component)Component.empty());
        this.pokemon = pokemon;
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"cobbreeding", (String)"textures/gui/neuter_button.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        this.texture = resourceLocation;
        ResourceLocation resourceLocation2 = ResourceLocation.fromNamespaceAndPath((String)"cobbreeding", (String)"textures/gui/cross.png");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"fromNamespaceAndPath(...)");
        this.cross = resourceLocation2;
    }

    @NotNull
    protected final Pokemon getPokemon() {
        return this.pokemon;
    }

    protected final void setPokemon(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"<set-?>");
        this.pokemon = pokemon;
    }

    @NotNull
    protected final ResourceLocation getTexture() {
        return this.texture;
    }

    protected final void setTexture(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.texture = resourceLocation;
    }

    @NotNull
    protected final ResourceLocation getCross() {
        return this.cross;
    }

    protected final void setCross(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"<set-?>");
        this.cross = resourceLocation;
    }

    public void onClick(double mouseX, double mouseY) {
        NetworkManager networkManager = Cobblemon.INSTANCE.getImplementation().getNetworkManager();
        UUID uUID = this.pokemon.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        networkManager.sendToServer((NetworkPacket)new ToggleNeuterPacket(uUID));
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        guiGraphics.blit(this.texture, this.getX(), this.getY(), this.width, this.height, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        if (NeuterProperty.Companion.get(this.pokemon)) {
            guiGraphics.blit(this.cross, this.getX() + 3, this.getY() + 3, 14, 14, 0.0f, 0.0f, 14, 14, 14, 14);
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)narrationElementOutput, (String)"narrationElementOutput");
        String isOn = !NeuterProperty.Companion.get(this.pokemon) ? "ON" : "OFF";
        narrationElementOutput.add(NarratedElementType.TITLE, "Breeding " + isOn);
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
        Intrinsics.checkNotNullParameter((Object)soundManager, (String)"soundManager");
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)((Holder)SoundEvents.UI_BUTTON_CLICK), (float)1.0f));
    }
}

