/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.Cobbreeding;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lludichat/cobbreeding/utils/CobbreedingFile;", "", "<init>", "()V", "Ljava/io/File;", "file", "", "key", "", "posValue", "Ljava/util/UUID;", "uuidValue", "", "addCompoundTag", "(Ljava/io/File;Ljava/lang/String;[ILjava/util/UUID;)V", "removeCompoundTag", "(Ljava/io/File;Ljava/lang/String;)V", "getUuid", "(Ljava/io/File;Ljava/lang/String;)Ljava/util/UUID;", "", "getNumberOfActivatedPastures", "(Ljava/io/File;)I", "encryptionFile", "keySize", "generateAESKey", "(Ljava/io/File;I)V", "Ljavax/crypto/SecretKey;", "getEncryptionKey", "()Ljavax/crypto/SecretKey;", "common"})
public final class CobbreedingFile {
    @NotNull
    public static final CobbreedingFile INSTANCE = new CobbreedingFile();

    private CobbreedingFile() {
    }

    @JvmStatic
    public static final void addCompoundTag(@NotNull File file, @NotNull String key, @Nullable int[] posValue, @Nullable UUID uuidValue) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            if (posValue != null && !(posValue.length == 0)) {
                nbt.putIntArray(key, posValue);
            }
            if (uuidValue != null) {
                nbt.putUUID(key, uuidValue);
            }
            NbtIo.write((CompoundTag)nbt, (Path)file.toPath());
        }
        catch (IOException e) {
            Cobbreeding.LOGGER.error("Couldn't write in file " + file.getPath());
        }
    }

    @JvmStatic
    public static final void removeCompoundTag(@NotNull File file, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            nbt.remove(key);
            NbtIo.write((CompoundTag)nbt, (Path)file.toPath());
        }
        catch (IOException e) {
            Cobbreeding.LOGGER.error("Couldn't write in file " + file.getPath());
        }
    }

    @JvmStatic
    @Nullable
    public static final UUID getUuid(@NotNull File file, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            return nbt.getUUID(key);
        }
        catch (IOException e) {
            Cobbreeding.LOGGER.error("Couldn't read in file " + file.getPath());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @JvmStatic
    public static final int getNumberOfActivatedPastures(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        CompoundTag nbt = new CompoundTag();
        try {
            if (file.exists()) {
                CompoundTag compoundTag = NbtIo.read((Path)file.toPath());
                Intrinsics.checkNotNull((Object)compoundTag);
                nbt = compoundTag;
            }
            return nbt.size();
        }
        catch (IOException e) {
            Cobbreeding.LOGGER.error("Couldn't read in file " + file.getPath());
        }
        catch (NullPointerException e) {
            return 0;
        }
        return -1;
    }

    @JvmStatic
    public static final void generateAESKey(@NotNull File encryptionFile, int keySize) {
        Intrinsics.checkNotNullParameter((Object)encryptionFile, (String)"encryptionFile");
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(keySize);
            String string = Base64.getEncoder().encodeToString(keyGenerator.generateKey().getEncoded());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
            FilesKt.writeText$default((File)encryptionFile, (String)string, null, (int)2, null);
        }
        catch (IOException e) {
            Cobbreeding.LOGGER.error("Couldn't create encryption key.");
        }
    }

    public static /* synthetic */ void generateAESKey$default(File file, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 128;
        }
        CobbreedingFile.generateAESKey(file, n);
    }

    @JvmStatic
    @NotNull
    public static final SecretKey getEncryptionKey() {
        File encryptionFile = new File("config/cobbreeding/encryption");
        if (!encryptionFile.exists()) {
            CobbreedingFile.generateAESKey$default(encryptionFile, 0, 2, null);
        }
        byte[] byArray = Base64.getDecoder().decode(FilesKt.readText$default((File)encryptionFile, null, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] decodedKey = byArray;
        return new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
    }
}

