/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental.lai;

import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.BattleState;
import com.gitlab.srcmc.rctapi.api.ai.experimental.lai.RatedAction;

public class BattleEvaluator {
    public static final double HEALTH_DIFF_WEIGHT = 0.8;
    public static final double STAT_BOOSTS_WEIGHT = 0.2;
    public static final double STATUS_EFFECTS_WEIGHT = 0.2;
    public static final double RATING_FACTOR = 0.5;
    public static final double RATING_DELTA_FACTOR = 0.85;

    public <T> void update(RatedAction<T> action, BattleState prevState, BattleState nextState) {
        action.addRating(0.5 * this.ratingDelta(action) * this.levelDiffDelta(prevState) * this.partyCountDelta(prevState) * (this.healthDelta(prevState, nextState) + this.boostsDelta(prevState, nextState) + this.statusDelta(prevState, nextState)));
    }

    protected <T> double ratingDelta(RatedAction<T> action) {
        double mid = 0.5;
        double rat = action.getRating() - 0.0;
        return 1.0 - 0.85 * Math.abs(rat - mid) / mid;
    }

    protected double levelDiffDelta(BattleState prevState) {
        return (100.0 - Math.min(100.0, Math.abs(prevState.sourceAverageLevel - prevState.targetAverageLevel))) / 100.0;
    }

    protected double partyCountDelta(BattleState prevState) {
        return (double)Math.min(6, prevState.sourcePartyCount) / 6.0;
    }

    protected double healthDelta(BattleState prevState, BattleState nextState) {
        double sourceHealthDelta = (double)(nextState.sourcePartyHealth - prevState.sourcePartyHealth) / (double)nextState.sourcePartyMaxHealth;
        double targetHealthDelta = (double)(nextState.targetPartyHealth - prevState.targetPartyHealth) / (double)nextState.targetPartyMaxHealth;
        return 0.8 * (sourceHealthDelta - targetHealthDelta);
    }

    protected double boostsDelta(BattleState prevState, BattleState nextState) {
        int sourceStatBoostsDelta = Math.max(-BattleState.MAX_STAT_BOOSTS, Math.min(BattleState.MAX_STAT_BOOSTS, nextState.sourcePartyStatBoosts - prevState.sourcePartyStatBoosts));
        int targetStatBoostsDelta = Math.max(-BattleState.MAX_STAT_BOOSTS, Math.min(BattleState.MAX_STAT_BOOSTS, nextState.targetPartyStatBoosts - prevState.targetPartyStatBoosts));
        return 0.2 * (double)(sourceStatBoostsDelta - targetStatBoostsDelta) / (double)BattleState.MAX_STAT_BOOSTS;
    }

    protected double statusDelta(BattleState prevState, BattleState nextState) {
        int sourceStatEffectsDelta = (nextState.sourcePartyStatusEffects - prevState.sourcePartyStatusEffects) / nextState.sourcePartyCount;
        int targetStatEffectsDelta = (nextState.sourcePartyStatusEffects - prevState.targetPartyStatusEffects) / nextState.targetPartyCount;
        return 0.2 * (double)(sourceStatEffectsDelta - targetStatEffectsDelta);
    }
}

