/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.ai.experimental.lai;

import java.util.function.Supplier;

class RatedAction<T> {
    public static final double MIN_RATING = 0.0;
    public static final double MAX_RATING = 1.0;
    private Supplier<T> supplier;
    private double rating;

    public RatedAction() {
        this(null, 0.5);
    }

    public RatedAction(Supplier<T> supplier) {
        this(supplier, 0.5);
    }

    public RatedAction(double rating) {
        this(null, rating);
    }

    public RatedAction(Supplier<T> supplier, double rating) {
        this.supplier = supplier;
        this.rating = Math.min(1.0, Math.max(0.0, rating));
    }

    public RatedAction<T> withSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
        return this;
    }

    public double getRating() {
        return this.rating;
    }

    public void addRating(double value) {
        this.rating = Math.max(0.0, Math.min(1.0, this.rating + value));
    }

    public T get() {
        return this.supplier.get();
    }
}

