/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctapi.api.errors;

import com.gitlab.srcmc.rctapi.api.errors.RCTError;
import com.gitlab.srcmc.rctapi.api.errors.RCTException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class RCTErrors<T extends RCTException> {
    private final Function<List<RCTError>, T> exceptionInitializer;
    private List<RCTError> errors = new ArrayList<RCTError>();

    private RCTErrors(@NotNull Function<List<RCTError>, T> exceptionInitializer) {
        this.exceptionInitializer = exceptionInitializer;
    }

    public static RCTErrors<RCTException> create() {
        return RCTErrors.create(RCTException::new);
    }

    public static <V extends RCTException> RCTErrors<V> create(@NotNull Function<List<RCTError>, V> exceptionInitializer) {
        return new RCTErrors<V>(exceptionInitializer);
    }

    public RCTErrors<T> add(@NotNull RCTError error) {
        this.errors.add(error);
        return this;
    }

    public <V> V expect(V got, Function<V, Boolean> predicate) {
        return (V)this.expect(got, predicate, () -> got, "invalid value '%s'");
    }

    public <V> V expect(V got, Function<V, Boolean> predicate, String format) {
        return (V)this.expect(got, predicate, () -> got, format);
    }

    public <V> V expect(V got, Function<V, Boolean> predicate, Supplier<V> otherwise) {
        return this.expect(got, predicate, otherwise, "invalid value '%s'");
    }

    public <V> V expect(V got, Function<V, Boolean> predicate, Supplier<V> otherwise, String format) {
        if (!predicate.apply(got).booleanValue()) {
            if (format.contains("%s")) {
                format = String.format(format, got != null ? got.toString() : got);
            }
            this.add(RCTError.of(format));
            return otherwise.get();
        }
        return got;
    }

    public <V> boolean doif(V got, Function<V, Boolean> predicate, Consumer<V> then) {
        return this.doif(got, predicate, then, "invalid value '%s'");
    }

    public <V> boolean doif(V got, Function<V, Boolean> predicate, Consumer<V> then, String format) {
        if (!predicate.apply(got).booleanValue()) {
            if (format.contains("%s")) {
                format = String.format(format, got != null ? got.toString() : got);
            }
            this.add(RCTError.of(format));
            return false;
        }
        then.accept(got);
        return true;
    }

    public void check() {
        if (this.errors.size() > 0) {
            throw (RCTException)this.exceptionInitializer.apply(this.errors);
        }
    }
}

