/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.common.block.entity.container;

import com.mojang.datafixers.util.Pair;
import ianm1647.expandeddelight.common.block.entity.JuicerBlockEntity;
import ianm1647.expandeddelight.common.block.entity.container.JuicerDrinkSlot;
import ianm1647.expandeddelight.common.block.entity.container.JuicerResultSlot;
import ianm1647.expandeddelight.common.crafting.JuicerRecipe;
import ianm1647.expandeddelight.common.registry.EDBlocks;
import ianm1647.expandeddelight.common.registry.EDMenuTypes;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class JuicerMenu
extends RecipeBookMenu<RecipeWrapper, JuicerRecipe> {
    private int output = 4;
    private int display = 2;
    private int bottle = 3;
    public static final ResourceLocation EMPTY_CONTAINER_SLOT_BOTTLE = ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)"item/empty_container_slot_bottle");
    public final JuicerBlockEntity tileEntity;
    public final ItemStackHandler inventory;
    private final ContainerData juicerData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public JuicerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, JuicerMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(4));
    }

    public JuicerMenu(int windowId, Inventory playerInventory, JuicerBlockEntity tileEntity, ContainerData juicerDataIn) {
        super(EDMenuTypes.JUICER.get(), windowId);
        int column;
        this.tileEntity = tileEntity;
        this.inventory = tileEntity.getInventory();
        this.juicerData = juicerDataIn;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)tileEntity.getLevel(), (BlockPos)tileEntity.getBlockPos());
        int startX = 8;
        int startY = 18;
        int inputStartX = 42;
        int inputStartY = 23;
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (column = 0; column < 1; ++column) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.inventory, row * 1 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.addSlot((Slot)new JuicerDrinkSlot((IItemHandler)this.inventory, this.display, 118, 26));
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.inventory, this.bottle, 86, 55){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_CONTAINER_SLOT_BOTTLE);
            }
        });
        this.addSlot((Slot)new JuicerResultSlot(playerInventory.player, tileEntity, (IItemHandler)this.inventory, this.output, 118, 55));
        int startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 142));
        }
        this.addDataSlots(juicerDataIn);
    }

    private static JuicerBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof JuicerBlockEntity) {
            return (JuicerBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(Player playerIn) {
        return JuicerMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)EDBlocks.JUICER.get());
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int indexMealDisplay = 2;
        int indexContainerInput = 3;
        int indexOutput = 4;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == indexOutput) {
                if (!this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (index > indexOutput) {
                if (itemstack1.getItem() == Items.GLASS_BOTTLE && !this.moveItemStackTo(itemstack1, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(itemstack1, 0, indexMealDisplay, false)) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(itemstack1, indexContainerInput, indexOutput, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public int getJuiceProgressionScaled() {
        int i = this.juicerData.get(0);
        int j = this.juicerData.get(1);
        return j != 0 && i != 0 ? i * 40 / j : 0;
    }

    public void fillCraftSlotsStackedContents(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.accountSimpleStack(this.inventory.getStackInSlot(i));
        }
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 2; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public boolean recipeMatches(RecipeHolder<JuicerRecipe> recipe) {
        return ((JuicerRecipe)recipe.value()).matches(new RecipeWrapper((IItemHandler)this.inventory), this.level);
    }

    public int getResultSlotIndex() {
        return 3;
    }

    public int getGridWidth() {
        return 1;
    }

    public int getGridHeight() {
        return 2;
    }

    public int getSize() {
        return 3;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.valueOf((String)"EXPANDEDDELIGHT_JUICING");
    }

    public boolean shouldMoveToInventory(int slot) {
        return slot < this.getGridWidth() * this.getGridHeight();
    }
}

