/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FeederBlockEntityRenderer
implements BlockEntityRenderer<FeederBlockEntity> {
    public static final HashMap<Integer, List<Pair<Float, Float>>> POSITIONS = new HashMap<Integer, List<Pair<Float, Float>>>(){
        {
            this.put(1, new ArrayList<Pair<Float, Float>>(){
                {
                    this.add(Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
                    this.add(Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
                    this.add(Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
                }
            });
            this.put(2, new ArrayList<Pair<Float, Float>>(){
                {
                    this.add(Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
                    this.add(Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.5f)));
                    this.add(Pair.of((Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.7f)));
                }
            });
            this.put(3, new ArrayList<Pair<Float, Float>>(){
                {
                    this.add(Pair.of((Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.3f)));
                    this.add(Pair.of((Object)Float.valueOf(0.5f), (Object)Float.valueOf(0.7f)));
                    this.add(Pair.of((Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.4f)));
                }
            });
        }
    };

    public FeederBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(FeederBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState slabState;
        IItemHandler invHandler;
        SlabType slabType = (SlabType)blockEntity.getBlockState().getValue((Property)SlabBlock.TYPE);
        if (blockEntity.getLevel() != null && (invHandler = (IItemHandler)blockEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockEntity.getBlockPos(), null)) instanceof ItemStackHandler) {
            int slot;
            ArrayList<ItemStack> filledSlots = new ArrayList<ItemStack>();
            for (slot = 0; slot < invHandler.getSlots(); ++slot) {
                ItemStack stack = invHandler.getStackInSlot(slot);
                if (stack.isEmpty()) continue;
                filledSlots.add(stack);
            }
            if (filledSlots.size() > 0) {
                for (slot = 0; slot < Math.min(3, invHandler.getSlots()); ++slot) {
                    ItemStack slotStack = invHandler.getStackInSlot(slot);
                    if (slotStack.isEmpty()) continue;
                    boolean isFlower = slotStack.is(ItemTags.FLOWERS);
                    Pair<Float, Float> pos = POSITIONS.get(Math.min(3, filledSlots.size())).get(slot);
                    float rotation = isFlower ? 90.0f : 35.0f * (float)slot;
                    float scale = isFlower ? 0.775f : 0.575f;
                    poseStack.pushPose();
                    poseStack.translate((double)((Float)pos.getFirst()).floatValue(), 0.52 + (slabType.equals((Object)SlabType.TOP) || slabType.equals((Object)SlabType.DOUBLE) ? 0.5 : 0.0), (double)((Float)pos.getSecond()).floatValue());
                    poseStack.mulPose(Axis.XP.rotationDegrees(rotation));
                    poseStack.scale(scale, scale, scale);
                    Minecraft.getInstance().getItemRenderer().renderStatic(slotStack, ItemDisplayContext.FIXED, combinedLightIn, combinedOverlayIn, poseStack, bufferIn, blockEntity.getLevel(), 0);
                    poseStack.popPose();
                }
            }
        }
        if ((slabState = blockEntity.baseBlock != null ? blockEntity.baseBlock.defaultBlockState() : Blocks.SMOOTH_STONE_SLAB.defaultBlockState()).getBlock() instanceof SlabBlock) {
            slabState = (BlockState)((BlockState)slabState.setValue((Property)SlabBlock.TYPE, (Comparable)((SlabType)blockEntity.getBlockState().getValue((Property)SlabBlock.TYPE)))).setValue((Property)SlabBlock.TYPE, (Comparable)slabType);
        }
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(slabState, poseStack, bufferIn, combinedLightIn, combinedOverlayIn);
    }
}

