/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeNBTChangerRecipe
implements Recipe<RecipeInput> {
    public final Supplier<BeeIngredient> bee;
    public final Ingredient item;
    public String attribute;
    public String method;
    public int value;
    public int min;
    public int max;

    public BeeNBTChangerRecipe(Supplier<BeeIngredient> ingredients, Ingredient item, String attribute, String method, int value, int min, int max) {
        this.bee = ingredients;
        this.item = item;
        this.attribute = attribute;
        this.method = method;
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BEE_NBT_CHANGER.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BEE_NBT_CHANGER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeeNBTChangerRecipe> {
        private static final MapCodec<BeeNBTChangerRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.CODEC.fieldOf("bee").forGetter(recipe -> recipe.bee), (App)Ingredient.CODEC.fieldOf("item").forGetter(recipe -> recipe.item), (App)Codec.STRING.fieldOf("attribute").forGetter(recipe -> recipe.attribute), (App)Codec.STRING.fieldOf("method").forGetter(recipe -> recipe.method), (App)Codec.INT.fieldOf("value").orElse((Object)0).forGetter(recipe -> recipe.value), (App)Codec.INT.fieldOf("min").orElse((Object)0).forGetter(recipe -> recipe.min), (App)Codec.INT.fieldOf("max").orElse((Object)100).forGetter(recipe -> recipe.max)).apply((Applicative)builder, BeeNBTChangerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeeNBTChangerRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BeeNBTChangerRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeeNBTChangerRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BeeNBTChangerRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                BeeIngredient bee = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                return new BeeNBTChangerRecipe((Supplier<BeeIngredient>)Lazy.of(() -> bee), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), buffer.readUtf(), buffer.readUtf(), buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee conversion recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BeeNBTChangerRecipe recipe) {
            try {
                recipe.bee.get().toNetwork((FriendlyByteBuf)buffer);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.item);
                buffer.writeUtf(recipe.attribute);
                buffer.writeUtf(recipe.method);
                buffer.writeInt(recipe.value);
                buffer.writeInt(recipe.min);
                buffer.writeInt(recipe.max);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee conversion recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

