/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class IncubationRecipe
implements Recipe<RecipeInput>,
TimedRecipeInterface {
    public final Ingredient input;
    public final Ingredient catalyst;
    public final ItemStack result;
    private final int processingTime;

    public IncubationRecipe(Ingredient input, Ingredient catalyst, ItemStack result, int processingTime) {
        this.input = input;
        this.catalyst = catalyst;
        this.result = result;
        this.processingTime = processingTime;
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime > 0 ? this.processingTime : (Integer)ProductiveBeesConfig.GENERAL.incubatorProcessingTime.get();
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.INCUBATION.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.INCUBATION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<IncubationRecipe> {
        private static final MapCodec<IncubationRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("input").forGetter(recipe -> recipe.input), (App)Ingredient.CODEC.fieldOf("input").forGetter(recipe -> recipe.catalyst), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("processingTime").orElse((Object)0).forGetter(recipe -> recipe.processingTime)).apply((Applicative)builder, IncubationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, IncubationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<IncubationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, IncubationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static IncubationRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                return new IncubationRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readInt());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee incubation recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, IncubationRecipe recipe) {
            try {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
                ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
                buffer.writeInt(recipe.getProcessingTime());
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee incubation recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

