/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class OreSolitaryNestFeature
extends SolitaryNestFeature {
    private final int yMin;
    private final int yMax;

    public OreSolitaryNestFeature(String probability, Codec<ReplaceBlockConfiguration> configFactory, int yMin, int yMax) {
        super(probability, configFactory);
        this.yMin = yMin;
        this.yMax = yMax;
    }

    @Override
    public boolean place(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos blockPos = context.origin();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.config();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.targetStates) {
            if (ProductiveBeesConfig.WORLD_GEN.nestConfigs.containsKey(this.configKey) && rand.nextFloat() > ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get(this.configKey).get()).floatValue()) {
                return false;
            }
            blockPos = blockPos.south(rand.nextInt(14)).east(rand.nextInt(14));
            blockPos = blockPos.above(this.yMin);
            while (blockPos.getY() < this.yMax) {
                if (!targetBlockState.target.test(world.getBlockState(blockPos = blockPos.above(2)), rand)) continue;
                return this.placeNest(world, blockPos, targetBlockState.state, rand);
            }
        }
        return true;
    }
}

