```json
{
  "title": "Crafter",
  "icon": "minecraft:crafter",
  "categories": [
    "minecraft:blocks",
    "minecraft:group.redstone_blocks"
  ],
  "associated_items": [
    "minecraft:crafter"
  ]
}
```

&spotlight(minecraft:crafter)
A **crafter** is a low-capacity storage [block](^minecraft:blocks) used for automatic [crafting](^minecraft:crafting). Its inventory acts as a [crafting table](^minecraft:crafting_table) that crafts when it is powered, ejecting the crafted item (or items) from its "mouth" into the world or into a container it is facing.

;;;;;

&title(Crafting)
<recipe;minecraft:crafter>

;;;;;

&title(Usage)

Crafters cannot be moved by [pistons](https://minecraft.wiki/w/Piston).‌


Its inventory slots can be individually locked to prevent [hoppers](https://minecraft.wiki/w/Hopper), [droppers](https://minecraft.wiki/w/Dropper), etc. from filling them; crafting recipes treat locked slots as empty of items.

;;;;;

&title(Container)
A crafter has nine slots of inventory space, arranged in a 3-by-3 grid like a [crafting table](^minecraft:crafting_table). Its GUI can be accessed by using it.

A slot can be enabled or disabled, which can be toggled by clicking on it when empty. Disabled slots cannot have items put in them.

;;;;;

&title(Container)
[Hoppers](https://minecraft.wiki/w/Hopper), [droppers](https://minecraft.wiki/w/Dropper) and other crafters interact with crafters by inserting items into its inventory; hoppers can remove ingredients as well. The added items are distributed from the top left to the bottom right of the enabled slots if there is an empty slot, if the crafter has all item slots filled then items are added to the lowest count item stack of the same type.

;;;;;

Hoppers and droppers can interact with all sides of the crafter, and prioritize filling empty spaces, followed by the smallest stack of the item.

;;;;;

&title(Redstone Component)
When a crafter receives a redstone signal, it waits for 2 [redstone ticks](https://minecraft.wiki/w/Redstone_tick) before ejecting one crafted item using the ingredients from the nine inventory slots. The crafted items are subsequently spit out from the front of the crafter. If the front of a crafter is facing a container (including another crafter), the crafted items are transferred into the container.

;;;;;

If the container it is facing is full, or the item cannot be inserted into the container, the crafter spits out the item instead. Crafters interact with containers [similar to droppers](https://minecraft.wiki/w/Dropper#Container_interactions). If a recipe has byproducts (e.g. empty bottles for honey blocks or empty buckets for cake) those are ejected after the crafted item.

;;;;;

&title(Redstone Component)
For shaped recipes, the position of the items in the inventory matters. Because disabled slots prevent items from entering the slot, crafters can be used to craft any item in the game automatically without any input from the player, using a series of hoppers and/or droppers and the correct configuration of disabled slots for the recipe.

;;;;;

A hopper placed below a crafter collects the ingredients from the crafting grid, not the resulting item. And unlike [dispensers](https://minecraft.wiki/w/Dispenser) and [droppers](https://minecraft.wiki/w/Dropper), crafters aren't affected by [quasi-connectivity](https://minecraft.wiki/w/Quasi-connectivity).

;;;;;

&title(Redstone Component)
Comparators can emit a redstone signal when reading from a crafter. The signal strength is equal to the number of crafting slots that are either disabled or occupied by an item. The stack size of the item has no effect on the comparators output signal e.g. having 1 stick in a slot vs having 64 sticks in that same slot both output the same comparator signal. 

;;;;;

An empty crafter with no disabled slots does not output any signal through a comparator. A crafter with every slot being disabled or containing an item (of any stack size) outputs a signal strength of nine through a comparator.

;;;;;

![Crafter](minecraft:textures/gui/image/crafter.png,fit)
A simple contraption for crafting [cake](https://minecraft.wiki/w/Cake) using the crafter.