```json
{
  "title": "Ominous Trial Spawner",
  "icon": "minecraft:trial_spawner[minecraft:block_state={ominous:\"true\"}]",
  "categories": [
    "minecraft:blocks",
    "minecraft:group.spawn_eggs"
  ]
}
```

<block;minecraft:trial_spawner[ominous=true,trial_spawner_state=active]>

An **ominous trial spawner** is a variant of the [trial spawner](^minecraft:trial_spawner) that gives better loot and spawns more armored mobs (when applicable).

;;;;;

It replaces a normal [trial spawner](^minecraft:trial_spawner) when a player having the [Trial Omen](^minecraft:trial_omen) effect approaches the trial spawner, during an [ominous trial](^minecraft:ominous_event). The ominous trial spawner can reward players with [ominous trial keys](^minecraft:ominous_trial_key) instead of normal [trial keys](^minecraft:trial_key).

;;;;;

&title(Obtaining)

The ominous trial spawner cannot be obtained as an item, because it is technically a block state of the normal trial spawner, not a separate block.

;;;;;

&title(Ominous Trial)
Trial spawners convert to ominous trial spawners if a [player](https://minecraft.wiki/w/Player) with the [Trial Omen](^minecraft:trial_omen) effect enters the 14 block detection area and is in the line of sight of the [trial spawner](^minecraft:trial_spawner). This also happens when the player has the [Bad Omen](^minecraft:bad_omen) effect, which gets converted into Trial Omen. 

;;;;;

&title(Ominous Trial)
When a trial spawner becomes ominous, all of its existing mobs are despawned. If the spawner was on cooldown and was not ominous before going on cooldown, the cooldown is skipped when becoming ominous. The ominous trial spawner then immediately becomes active.

;;;;;

&title(Breaking)
An ominous spawner can be broken but it does not drop itself as an item and takes a long time to break.

Due to their high blast resistance, trial spawners are immune to [explosions](https://minecraft.wiki/w/Explosion), but can still be destroyed by the [wither](https://minecraft.wiki/w/Wither)'s block-breaking attack and blue wither skulls. 

;;;;;

&title(Usage)
The ominous trial spawner is similar to the [trial spawner](^minecraft:trial_spawner), but releases more difficult mobs and ejects more powerful loot.

;;;;;

&title(Mob Spawning)
Ominous trial spawners converted from trial spawners that generate naturally in [trial chambers](^minecraft:trial_chambers) spawn mobs with (better) weapons and wearing armor. Ominous Trial Spawners with mobs that are unable to wear equipment spawn double the total mob count over the course of the challenge. These spawners will also spawn an additional mob out at once during its challenge.

;;;;;

&title(Projectile Spawning)
When at least one player is within the activation range of an ominous trial spawner, every 8 seconds it spawns [ominous item spawners](https://minecraft.wiki/w/Ominous_item_spawner) above any such player or any mob that was spawned by this ominous trial spawner. The ominous item spawner displays a projectile for 3 to 6 seconds before shooting that projectile downwards. 

;;;;;

Each ominous trial spawner has a set of 2 projectiles it spawns, one of which is a [lingering potion](https://minecraft.wiki/w/Lingering_potion). The lingering potion effect is selected randomly from one of the following: [Wind Charged](^minecraft:wind_charged), [Oozing](^minecraft:oozing), [Weaving](^minecraft:weaving), [Infested](^minecraft:infested), [Strength](https://minecraft.wiki/w/Strength), [Speed](^minecraft:speed), [Slow Falling](https://minecraft.wiki/w/Slow_Falling).

The second projectile is randomly selected from: [Arrow](https://minecraft.wiki/w/Arrow), [Arrow of Poison](https://minecraft.wiki/w/Arrow_of_Poison), [Arrow of Slowness](https://minecraft.wiki/w/Arrow_of_Slowness) IV, [Fire Charge](https://minecraft.wiki/w/Fire_charge), [Wind Charge](^minecraft:wind_charge).

