```json
{
  "title": "Trial Spawner",
  "icon": "minecraft:trial_spawner",
  "categories": [
    "minecraft:blocks",
    "minecraft:group.functional_blocks"
  ],
  "associated_items": [
    "minecraft:trial_spawner"
  ]
}
```

&spotlight(minecraft:trial_spawner)
A **trial spawner** is a type of [spawner](https://minecraft.wiki/w/Spawner) found only within [trial chambers](^minecraft:trial_chambers). It spawns [mobs](^minecraft:mobs) in waves, which increase in number the more [Survival](https://minecraft.wiki/w/Survival)/[Adventure](https://minecraft.wiki/w/Adventure) mode [players](https://minecraft.wiki/w/Player) are nearby.

;;;;;

When all of its spawned mobs are defeated, it ejects a combination of consumable items and/or [trial keys](^minecraft:trial_key), then goes inactive for 30 minutes. It cannot be obtained as an item or moved by a [piston](https://minecraft.wiki/w/Piston). A trial spawner converts into an [ominous trial spawner](^minecraft:ominous_trial_spawner) during an [ominous trial](^minecraft:ominous_event).

;;;;;

&title(Obtaining)

Trial spawners cannot be obtained in [Survival](https://minecraft.wiki/w/Survival), even with [Silk Touch](https://minecraft.wiki/w/Silk_Touch), and can not be moved with a [piston](https://minecraft.wiki/w/Piston).

;;;;;

&title(Natural generation)
Trial spawners generate naturally in every chamber and every corridor of [trial chambers](^minecraft:trial_chambers), except for the entrance chamber. 

;;;;;

&title(Breaking)
A trial spawner can be broken but it does not drop itself as an item and takes a long time to break. It can only be obtained via the [Creative inventory](https://minecraft.wiki/w/Creative_inventory), the */[give](https://minecraft.wiki/w/Commands/give)* command, or by using [pick block](https://minecraft.wiki/w/Pick_block).

Due to their high blast resistance, trial spawners are immune to [explosions](https://minecraft.wiki/w/Explosion), but can still be destroyed by the [wither](https://minecraft.wiki/w/Wither)'s block-breaking attack and blue wither skulls. 

;;;;;

&title(Usage)
A trial spawner summons a limited number of mobs, scaled based on the number of nearby [players](https://minecraft.wiki/w/Player). When these mobs are defeated, the spawner drops a reward for each player and enters a cooldown period.

;;;;;

&title(Activation)
The trial spawner has a required player range of 14 blocks. Any player in Survival or Adventure mode activates the spawner if the [distance](https://minecraft.wiki/w/Distance) between the player's center and the spawner's center becomes less than the required player range. Once activated, the spawner begins summoning copies of the mob set in it.

;;;;;

Trial spawners do not activate in [Peaceful](https://minecraft.wiki/w/Peaceful) difficulty, or if the gamerule doMobSpawning is false, even if set to an entity capable of spawning in Peaceful.

When a trial spawner first activates, it shoots spark-like particles up into the air. While active, it emits smoke and flame particles around itself and any entities it summons.

The light level around a trial spawner does not affect how it summons entities. 

;;;;;

&title(Mob Spawning)
When a player enters the trial spawner's range, the spawner attempts to spawn 1 mob every 40 game ticks (2 seconds). With 1 player, it does not spawn a mob if there are already 2 mobs from the spawner that are still alive. It will spawn a total of 6 mobs before ejecting loot and going into cooldown. 

;;;;;

&title(Completion)
All mobs spawned by the trial spawner must be defeated before the trial spawner can drop loot. A mob is considered defeated when is either killed or transformed into another entity.

If a mob spawns more mobs upon death, only the initial mob must be defeated in order to complete the spawner (i.e. slimes and magma cubes). 

;;;;;

&title(Cooldown)
Upon completion, the trial spawner enters a cooldown state for 30 minutes (36000 game ticks) before it can be activated again. 

