```json
{
  "title": "Bundle",
  "icon": "minecraft:bundle",
  "categories": [
    "minecraft:items",
    "minecraft:group.tools_and_utilities"
  ],
  "associated_items": [
    "#minecraft:bundles"
  ]
}
```

&tag-spotlight(minecraft:bundles)
A **bundle** is an item that can store up to a stack's worth of mixed item types within itself in a single inventory slot.

;;;;;

&title(Crafting)
<recipe;minecraft:bundle>
<recipe;minecraft:white_bundle>

;;;;;

&title(Storage)
Bundles are used to store different item types in the same inventory slot. This does not, however, increase the total capacity of the slot, as bundles can only store what adds up to a single slot.

;;;;;

&title(Pack Sizes)
Items that can normally stack up to 64 take up 1/64 of a bundle, items that can normally stack up to 16 (eg. eggs) take up 1/16 of a bundle, and items that can't stack take up the entirety of a bundle (with exception to bundles themselves).

;;;;;

&title(Space)
Space that an item takes up in a bundle is equal to the reciprocal of its max_stack_size component, even if it is different from the standard 1, 16, and 64.

;;;;;

&title(Stacking)
Bundles are not stackable, but they are able to be placed (nested) inside another, and will always take up 1/16 of the space of a bundle, regardless of their max_stack_size component, plus the space occupied by the inner bundle's contents.

;;;;;

&title(Shulker Boxes)
Shulker boxes cannot be placed inside of bundles. However, bundles **can** be placed inside of shulker boxes.

;;;;;

&title(Inserting and Retrieving)
Items are inserted into bundles by {gold}left-clicking{}, and retrieved by {gold}right-clicking{}. 