```json
{
  "title": "Eyeblossom",
  "icon": "minecraft:open_eyeblossom",
  "categories": [
    "minecraft:blocks",
    "minecraft:tag.small_flowers",
    "minecraft:group.natural_blocks"
  ],
  "associated_items": [
    "minecraft:open_eyeblossom",
    "minecraft:closed_eyeblossom"
  ]
}
```

&spotlight(minecraft:open_eyeblossom)
An **eyeblossom** is a unique [flower](^minecraft:tag.flowers) found in the [pale garden biome](^minecraft:pale_garden). It changes state depending on the daylight cycle, closing during the day and opening at night. Its "eye", visible only when the flower is open, glows in the dark but does not emit light.

;;;;;

&title(Breaking)
An eyeblossom can be broken instantly with any item or by hand, dropping itself in its current state.


An eyeblossom also breaks if water or lava runs over its location, if a piston extends or pushes a block into its location, or if a block under the plant is moved or destroyed.

;;;;;

&title(Natural Generation)
Eyeblossoms generate naturally on grass blocks or [pale moss blocks](^minecraft:pale_moss_block) in the [pale garden](^minecraft:pale_garden) biome.

;;;;;

&title(Trading)
<|wandering-trader@minecraft:knowlogy_components|price=5,given-item=minecraft:open_eyeblossom,given-quantity=,stock=7|>

Open eyeblossoms can be obtained by trading with a wandering trader, who may sell it for 1 emerald. Wandering traders do not sell closed eyeblossoms.

;;;;;

&title(Post-Generation)
When bone meal is applied to a grass block in a [pale garden](^minecraft:pale_garden) biome, eyeblossoms have a chance of generating on the targeted block and adjacent grass blocks in a 15×5×15 area. Eyeblossoms generate closed or open depending on the time of day.

;;;;;

&title(Usage)
Like other [flowers](^minecraft:tag.flowers), eyeblossoms can be used as decoration and planted on grass blocks, dirt, coarse dirt, rooted dirt, farmland, podzol, mycelium, [moss blocks](^minecraft:moss_block), [pale moss blocks](^minecraft:pale_moss_block), [mud](^minecraft:mud), or [muddy mangrove roots](^minecraft:muddy_mangrove_roots).


Eyeblossoms can be placed in flower pots.

;;;;;

&title(Opening and closing)
Eyeblossoms are closed during the day, and open when it is night. Eyeblossoms planted on the ground communicate with each other by emitting a particle signaling when to open or close. Eyeblossoms can communicate with each other within a 3 block radius and eyeblossoms within said range will randomly open and close.

;;;;;

&title(Opening and closing)
Eyeblossoms stay in their current state when placed in the [Nether](^minecraft:the_nether) or the [End](^minecraft:the_end) and do not change. Breaking an eyeblossom yields its current state as an item form.

;;;;;

&title(Redstone Component)
Eyeblossom are detected by observers and [sculk sensors](^minecraft:sculk_sensor) when they open or close.

;;;;;

&title(Crafting Ingredient)
<recipe;minecraft:orange_dye_from_open_eyeblossom>
<recipe;minecraft:gray_dye_from_closed_eyeblossom>

;;;;;

&title(Suspicious Stew)
Using an open eyeblossom to make suspicious stew, whether by direct crafting or by feeding a brown mooshroom and then milking it with a bowl, imbues it with a Blindness that lasts 11 seconds. Making suspicious stew with a closed eyeblossom imbues the stew with a Nausea effect that lasts 7 seconds.

;;;;;

&title(Bees)
When a [bee](^minecraft:bee) touches an open eyeblossom on any difficulty other than Peaceful, it is inflicted with the Poison effect for 1.25 seconds (25 game ticks). Despite this, bees can still pollinate open eyeblossoms as they do with other [flowers](^minecraft:tag.flowers).

;;;;;

&title(Bees)
Bees do not interact with closed eyeblossoms. They are not attracted by closed eyeblossoms, do not get poisoned if they touch one, and cannot be fed one.

;;;;;

&title(Breeding)
Open eyeblossoms can be used to lead [bees](^minecraft:bee), but cannot be used to [breed](^minecraft:breeding) them or grow baby bees. Feeding a bee an open eyeblossom inflicts it with the Poison effect for 1.25 seconds (25 game ticks), without angering the bee.

;;;;;

&title(Bee Nests)
Oak, birch, and [cherry trees](^minecraft:cherry_tree) grown from saplings that are within 2 blocks of a eyeblossom have a 5% chance to grow with a [bee nest](^minecraft:bee_nest) and 2-3 [bees](^minecraft:bee) in it.

;;;;;

&title(Composting)
Placing a eyeblossom into a composter has an 85% chance of raising the compost level by 1.