#if ! defined INCLUDE_DEFERRED_VSH_80C4
#define INCLUDE_DEFERRED_VSH_80C4

#include "/lib/settings.glsl"
#include "/core/math.glsl"
#include "/lib/utils.glsl"
#include "/lib/vertex_transform_composite.glsl"
#if ! defined INCLUDE_UNIFORM_int_heldItemId
#define INCLUDE_UNIFORM_int_heldItemId
uniform int heldItemId; 
#endif

#if ! defined INCLUDE_UNIFORM_int_heldBlockLightValue
#define INCLUDE_UNIFORM_int_heldBlockLightValue
uniform int heldBlockLightValue; 
#endif

#if ! defined INCLUDE_UNIFORM_int_heldItemId2
#define INCLUDE_UNIFORM_int_heldItemId2
uniform int heldItemId2; 
#endif

#if ! defined INCLUDE_UNIFORM_int_heldBlockLightValue2
#define INCLUDE_UNIFORM_int_heldBlockLightValue2
uniform int heldBlockLightValue2; 
#endif
flat out vec4 handLight; // rgb: color, a: brightness

vec4 getHandlightColor(int itemId) {
	switch (itemId) {
		case 20: return vec4(1);                         // White
		case 21: return vec4(HANDLIGHT_COLOR_ORANGE, 1); // Orange
		case 22: return vec4(HANDLIGHT_COLOR_RED, 1);    // Red
		case 24: return vec4(HANDLIGHT_COLOR_BLUE, 1);   // Blue
		case 25: return vec4(HANDLIGHT_COLOR_PURPLE, 1); // Purple
	}
	return vec4(0);
}

void main() {
	gl_Position = getPosition();

	/* vec4  handLight1 = getHandlightColor( getID(heldItemId) );
	vec4  handLight2 = getHandlightColor( getID(heldItemId2) );
	float brightness = heldBlockLightValue / 15.;

	if (handLight1.a == 0 && handLight2.a == 0) {
		handLight = vec4(0);
	} else {
		handLight.rgb = (handLight1.rgb + handLight2.rgb) / (handLight1.a + handLight2.a);
		handLight.a   = brightness;
	} */

	vec4  handLight1           = getHandlightColor( getID(heldItemId) );
	vec4  handLight2           = getHandlightColor( getID(heldItemId2) );
	float handLight1Brightness = heldBlockLightValue / 15.; 
	float handLight2Brightness = heldBlockLightValue2 / 15.; 

	if (handLight1.a == 0 && handLight2.a == 0) {
		handLight = vec4(0);
	} else {
		handLight.rgb = (handLight1.rgb + handLight2.rgb) / (handLight1.a + handLight2.a);
		handLight.a   = handLight1Brightness + handLight2Brightness;
	}
		
}

#endif