#if ! defined INCLUDE_GBUFFERS_SKYTEXTURED_FSH_813B
#define INCLUDE_GBUFFERS_SKYTEXTURED_FSH_813B

#include "/lib/settings.glsl"
#include "/core/math.glsl"
#include "/lib/utils.glsl"
#include "/lib/gbuffers_basics.glsl"

in vec2 coord;

#ifdef HORIZON_CLIP
#if ! defined INCLUDE_UNIFORM_vec3_up
#define INCLUDE_UNIFORM_vec3_up
uniform vec3 up; 
#endif
in vec3 viewPos;
#endif

#if SUN_RAIN_OPACITY != 100
#if ! defined INCLUDE_UNIFORM_float_rainStrength
#define INCLUDE_UNIFORM_float_rainStrength
uniform float rainStrength; 
#endif
#endif

#ifdef AURORA
    in float isAurora;
#endif

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 FragOut0;
void main() {
	vec4 color = getAlbedo(coord);

#ifdef HORIZON_CLIP
    color.rgb *= saturate(dot(normalize(viewPos), up) * HORIZON_CLIP_TRANSITION - (HORIZON_CLIP_HEIGHT * HORIZON_CLIP_TRANSITION));
#endif

#if SUN_RAIN_OPACITY != 100
    color.rgb *= (1. - rainStrength * (1 - sun_rain_opacity));
#endif

#if DITHERING >= 2
    color.rgb += ditherColor(gl_FragCoord.xy);
#endif

	FragOut0 = color;
    
#ifdef AURORA

    if (isAurora == 1) {
        vec4 aurora = vec4(1);

        aurora.rgb = vec3(0,1,0.5) * (sin(coord.x * TWO_PI * 20) * .4 + .6);

        aurora.a *= exp2(-(coord.y - 0.1) * 10);

        aurora.a *= 1 - sq(sqmag(coord * 2 - 1));
        FragOut0 = vec4(aurora.rgb * aurora.a, 1);

        //FragOut0.rgb = vec3(snoise(coord.x * 10) * 0.5);
    }

#endif

}

#endif